package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 签名请求的基础信息参数
 * 
 * @author DJQ 2018-07-05
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId; // 用户ID

  @NotNull(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL)
  private Long documentId; // 文书ID

  @NotNull(message = RefereeValidateMessage.PARAMETER_IMG_ID_NULL)
  private String imgId; // 图像文件ID

  @NotNull(message = RefereeValidateMessage.PARAMETER_IMG_DEGREE_NULL)
  private Integer degree; // 旋转度数90，180，270

  public SignatureInfoReqDTO(SignatureInfoReqDTO signInfoReq,
      @NotEmpty(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL) Long documentId) {
    super();
    this.documentId = documentId;
    this.degree = signInfoReq.getDegree();
    this.imgId = signInfoReq.getImgId();
    this.userId = signInfoReq.getUserId();
  }

}
