package com.beiming.odr.referee.dto.requestdto;

import javax.validation.constraints.NotNull;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.enums.SuitTypeEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Created by zli on 2018/7/13.
 *
 * 诉讼列表入参
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SuitListReqDTO extends PageQuery {
  private static final long serialVersionUID = -8231854389136873506L;

  /**
   * 创建者id
   */
  private Long userId;

  /**
   * 诉讼或司法确认
   */
  @NotNull(message = "诉讼类型不能为空")
  private SuitTypeEnums type;
  
  /**
   * 当事人手机号
   */
  private String mobilePhone;
}
