package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 转移调解区域请求类
 * 
 * @author chenjt
 * @data 2019年9月8日
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TransferMediationAreaReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "案件id不能为空")
  private Long caseId;
  @NotBlank(message = "转出区域代码不能为空")
  private String fromAreaCode;
  @NotBlank(message = "转入区域代码不能为空")
  private String toAreaCode;
  private String reason; // 原因
  @NotNull(message = "用户id不能为空")
  private Long userId;
  @NotBlank(message = "用户名不能为空")
  private String userName;
}
