package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件列表（同步机构）
 * 
 * @ClassName: MediationListOrgsResDTO.java
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月26日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationListOrgsResDTO implements Serializable {

  private static final long serialVersionUID = -8195522329212007987L;

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private String lawCaseStatus; // 案件状态
  private String caseProgress; // 案件进度
  private Long orgId; // 登记机构ID
  private String orgName; // 登记机构名称
  private String disputeContent; // 纠纷描述
  private Date createTime; //  调解登记时间
  private Date endTime; //  调解结束时间
  private String syncOrgName; // 同步机构名称
  private String suitNo; // 诉讼OR司法编号

}
