package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 视频列表
 * 
 * @author qsh
 * @date 2019年2月20日
 */
@Data
@NoArgsConstructor
public class MediationMeetingRoomUserInfoResDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  private Long id;
  /**
   * 调解室/视频会议名字
   */
  private String name;

  private Long parentId;
  /**
   * 调解/视频会议状态
   */
  private String mediationStatus;

  /**
   * 是否电话外呼
   */
  private int callFlag;

  /**
   * 是否需要身份验证
   */
  private int authFlag;
  /**
   * 调解/视频会议
   */
  private String mediationMeetingType;

  /**
   * 会议预订时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime;
  /**
   * 会议结束时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date endTime;

  /**
   * 调解室/会议视频房间id
   */
  private String roomId;

  /**
   * 创建人员id
   */
  private Long creatorId;
  /**
   * 创建人员
   */
  private String createUser;

  /**
   * 参会人员列表
   */
  List<MediationRoomUserInfoResDTO> list;
}
