package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 微解纷 - 调解视频会议 待办列表
 * 
 * @author chenjt 2019-02-20 17:30:00
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MediationMeetingStayResDTO implements Serializable {

  private static final long serialVersionUID = 7897654472309434783L;

  /**
   * 会议ID
   */
  private Long id;
  /**
   * 会议名称
   */
  private String name;
  /**
   * 会议房间ID
   */
  private String roomId;
  /**
   * 会议状态
   */
  private String mediationStatus;
  /**
   * 会议开始时间
   */
  private Date startTime;
  /**
   * 会议预约时间
   */
  private Date orderTime;
  /**
   * 会议结束时间
   */
  private Date endTime;

  /**
   * 会议创建时间
   */
  private Date createTime;
  /**
   * 是否需要身份验证
   */
  private String authFlag;
  /**
   * 与会人
   */
  private List<MediationRoomUserInfoResDTO> meetingUsers;


}
