package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 调解室人员返回实体类
 * @Author: caiwei
 * @Date: 2019/2/27
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MediationRoomPersonResDTO implements Serializable {

  private static final long serialVersionUID = -6084404070431259316L;

  /**
   * 人员id
   */
  private Long personId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户类型（申请人、被申请人、当事人）
   */
  private String meetingUserType;

  /**
   * 用户类型（申请人、被申请人、当事人）
   */
  private String userType;

  /**
   * 手机号
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户排序
   */
  private String userOrder;

  /**
   * 代理当事人id
   */
  private Long agentParentId;
}