package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.NoArgsConstructor;

/**
 * 微解纷视频记录
 * 
 * @author qsh
 * @date 2019年2月22日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MeetingVideoResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  private String joinUser;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date uploadTime;
  private String download;
  private String preview;
  private String userType;
  private String meetingName;
  
  public MeetingVideoResDTO meetingVideoResCoversion(String playUrl, Long startTime,
      String joinUser, String memberType) {
    MeetingVideoResDTO meetingVideoResDTO = new MeetingVideoResDTO();
    meetingVideoResDTO.setDownload(playUrl);
    meetingVideoResDTO.setJoinUser(joinUser);
    meetingVideoResDTO.setPreview(playUrl);
    meetingVideoResDTO.setUploadTime(new Date(startTime));
    meetingVideoResDTO.setUserType(memberType);
    meetingVideoResDTO.setMeetingName(joinUser);
    return meetingVideoResDTO;
  }
}
