package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 协议书返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProtocolBookResDTO implements Serializable {

  private static final long serialVersionUID = 6873992566898576323L;
  // 协议书
  private Long protocolId;

  // 案件号
  private String caseNo;

  // 申请方
  private List<CaseProtocolPersonnelResDTO> applicantList;

  // 被申请方
  private List<CaseProtocolPersonnelResDTO> respondentList;

  // 争议事项或调解过程
  private String content;

  // 达成协议或者无争议事实
  private String extendJson;

  // 协议是否发送
  private String sendStatus;

  // 相关人员签名详情
  private List<CaseWholeConfirmResDTO> confirmList;

  // 协助调解员
  private List<MediatorHelpPersonResDTO> mediatorHelpPersonList;
}
