package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * @author chen
 * @date 2024/08/02
 */
@Data
public class ReAppealHeaderResDTO implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = -4937782046942168417L;
  /**
   * id
   */
  private Long id;

  /**
   * 调解案件id
   */
  private Long caseId;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;


  /**
   * 工单单号
   */
  private String appealNo;

  /**
   * 工单类型（MEDIATION：调解, LETTERS_VISITS：信访, COMPLAINT：投诉, OTHER：其他)
   */
  private String type;

  /**
   * 登记类型（用户登记：COMMON，登记员登记：REGISTRAR）
   */
  private String creatorType;

  /**
   * 工单分类1（备用字段）
   */
  private String classify1;

  /**
   * 工单分类2（备用字段）
   */
  private String classify2;

  /**
   * 工单分类3（备用字段）
   */
  private String classify3;

  /**
   * 工单分类4（备用字段）
   */
  private String classify4;

  /**
   * 工单分类5（备用字段）
   */
  private String classify5;

  /**
   * 查询密码（用户查询时用）
   */
  private String queryPwd;

  /**
   * 标题
   */
  private String title;

  /**
   * 问题描述（只保存前100字，detail表保存完整内容）
   */
  private String content;

  /**
   * 事件发生地编码
   */
  private String areaCode;

  /**
   * 事件发生地名称
   */
  private String areaName;

  /**
   * 诉求所在地code
   */
  private String locationCode;

  /**
   * 诉求所在地名称
   */
  private String locationName;

  /**
   * 事件发生地详细地址
   */
  private String addressDetail;

  /**
   * 工单来源(SU_FU：诉服, RE_XIAN：热线, XIN_FANG：信访, GONG_FA：公法)
   */
  private String transferFromType;

  /**
   * 工单来源单号
   */
  private String transferFromNo;

  /**
   * 登记单位id
   */
  private Long regOrgId;

  /**
   * 登记单位名称
   */
  private String regOrgName;

  /**
   * 承办单位类型
   */
  private String processAppealOrgType;

  /**
   * 登记人ID
   */
  private Long regUserId;

  /**
   * 登记人
   */
  private String regUserName;

  /**
   * 当事人ID
   */
  private Long litigantId;

  /**
   * 当事人姓名
   */
  private String litigantName;

  /**
   * 当事人证件类型
   */
  private String litigantCardType;

  /**
   * 当事人证件号码
   */
  private String litigantIdCard;

  /**
   * 当事人手机号
   */
  private String litigantPhone;

  /**
   * 当事人年龄
   */
  private Integer litigantAge;

  /**
   * 当事人性别（MALE：男，FEMALE：女）
   */
  private String litigantSex;

  /**
   * 流程状态code
   */
  private String appealStatus;

  /**
   * 流程状态名称
   */
  private String appealStatusName;

  /**
   * 承办单位ID
   */
  private Long processOrgId;

  /**
   * 承办单位名字
   */
  private String processOrgName;

  /**
   * 承办单位区域code
   */
  private String processOrgAreaCode;

  /**
   * 承办人ID
   */
  private Long processUserId;

  /**
   * 承办人名字
   */
  private String processUserName;
  /**
   * 承办人名字
   */
  private String processUserPhone;

  /**
   * 转单类型（同type）
   */
  private String transferToType;

  /**
   * 工单转单后关联单号
   */
  private String transferToNo;

  /**
   * 红黄蓝牌code
   */
  private String cardType;

  /**
   * 是否已延期 0 否 1 是
   */
  private Integer delayStatus;


  /**
   * 应玩成时间
   */
  private Date deadline;

  /**
   * 分平台类型（LETTERS_VISITS：信访,  GRID：网格）
   */
  private String thirdPlatformType;

  /**
   * 分平台对应诉求的id
   */
  private String thirdPlatformId;

  /**
   * 工单详情 json
   */
  private String appealDetail;

  /**
   * 诉求难易度
   */
  private String difficultyType;

  /**
   * 入驻机构id数组
   */
  private List<Long> joinOrgIds;

  /**
   * 审核重新分配标识
   */
  private boolean auditReassignFlag;

  /**
   * 风险标签
   */
  private List<String> riskTags;

  /**
   * 诉求文书标识
   */
  private Boolean appealDocFlag;

  /**
   * 申请人手机号
   */
  private List<String> applicantPhoneList;

  /**
   * 承办单位等级
   */
  private Integer processOrgLevel;
}
