package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.beiming.framework.util.Date2LongSerialize;
import com.beiming.odr.referee.dto.ProgressDTO;
import com.beiming.odr.referee.enums.SuitStatusEnum;
import com.beiming.odr.referee.enums.SuitTypeEnums;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 诉讼列表
 */
@Data
public class SuitListResDTO implements Serializable {

  private static final long serialVersionUID = 3255792401666166867L;
  /**
   * 主键
   */
  private Long id;
  /**
   * 诉讼或司法确认
   */
  private SuitTypeEnums type;
  /**
   * 立案申请ID
   */
  private String thirdSuitId;
  
  /**
   * 诉讼/司法编号
   */
  private String suitNo;

  /**
   * 案由
   */
  private String causeName;

  /**
   * 诉求信息
   */
  private String appeal;

  /**
   * 创建时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;

  /**
   * 法院名称
   */
  private String courtName;

  /**
   * 诉讼状态
   *
   * SUCCESS 已审核
   * FAILED 已失效
   * 其它都为 待审核
   */
  private SuitStatusEnum suitStatus;

  /**
   * 申请人
   */
  private List<String> applicants;

  /**
   * 被申请人
   */
  private List<String> respondents;

  /**
   * 进度条
   */
  private List<ProgressDTO> progressList;

  /**
   * 纠纷类型
   */
  private String disputeType;

  private Long lawCaseId;
}
