package com.beiming.odr.referee.enums;

/**
 * 进度类型 案件进度，卷宗进度，诉讼进度
 * 
 * @author qsh
 * @data 2018年6月29日
 */
public enum SubjectTypeEnum {
  /**
   * 卷宗进度类型
   */
  DOSSIER_TYPE("dossier"),
  /**
   * 案件进度类型
   */
  LAW_CASE_TYPE("law_case"),
  /**
   * 会议进度类型
   */
  MEETING_TYPE("meeting"),
  /**
   * 诉讼进度类型
   */
  LAW_SUIT_TYPE("law_suit"),
  /**
   * 卷宗封面，封底，卷内目录，不在前端显示
   */
  DOSSIER_WORD("dossier_word"),
  /**
   * 鉴定进度类型
   */
  APPRAISAL_TYPE("appraisal"),

  /**
   * 评估类型
   */
  EVALUATION_TYPE("evaluation");
  
  private String name;

  /**
   * @param name
   */
  private SubjectTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

}
