package com.beiming.odr.user.api;

import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.CommonOrgIdReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;


@RestController
@RequestMapping(UserConst.URL_PREFIX + "/appealOrganization")
public interface AppealOrganizationServiceApi {
  
  /**
   * 通过机构id获取本级及子级诉求机构列表
   */
  @RequestMapping(value = "getAppealOrganizationListByOrgId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getAppealOrganizationListByOrgId(
      @RequestBody CommonOrgIdReqDTO commonOrgIdReqDTO);
  
  /**
   * 通过父级id获取机构
   */
  @RequestMapping(value = "getOrganizationListByParentId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getOrganizationListByParentId(
      @RequestParam(name = "parentId") Long parentId, @RequestParam(name = "appealOrgType") String appealOrgType);

  /**
   * 通过机构id获取父级机构信息
   */
  @RequestMapping(value = "getParentOrgInfo", method = {RequestMethod.POST})
  public DubboResult<OrganizationResDTO> getParentOrgInfo(@RequestParam(name = "orgId") Long orgId);

  /**
   * 通过机构id获取上级中心信息
   */
  @RequestMapping(value = "getSuperiorCenter", method = {RequestMethod.POST})
  public DubboResult<OrganizationResDTO> getSuperiorCenter(@RequestParam(name = "orgId") Long orgId);
}
