package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.AllAreasInfoDTO;
import com.beiming.odr.user.api.dto.AreasInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AreaPageReqDTO;
import com.beiming.odr.user.api.dto.requestdto.AreaReqDTO;
import com.beiming.odr.user.api.dto.responsedto.AreasResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/area")
public interface AreaServiceApi {

  /** 查询地域信息-不分页 */
  @RequestMapping(value = "searchAreasInfo", method = {RequestMethod.POST})
  DubboResult<AreasResDTO> searchAreasInfo(@RequestBody AreaReqDTO areaReqDTO);

  /**
   * 获取本级及下级区域信息
   * 
   * @param areaCode
   * @return
   */
  @RequestMapping(value = "getLowerLevelAreasInfo", method = {RequestMethod.POST})
  DubboResult<AreasResDTO> getLowerLevelAreasInfo(@RequestParam(name = "areaCode") String areaCode);

  /** 查询地域信息-分页 */
  @RequestMapping(value = "searchAreasPageInfo", method = {RequestMethod.POST})
  DubboResult<PageInfo<AreasInfoDTO>> searchAreasPageInfo(@RequestBody AreaPageReqDTO req);
  
  /**
   * 获取省市区街道社区，五级行政区域
   * @param areaCode
   * @return
   */
  @RequestMapping(value = "getAllAreasInfo", method = {RequestMethod.POST})
  DubboResult<AllAreasInfoDTO> getAllAreasInfo(@RequestParam(name = "areaCode") String areaCode);
}
