package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrgUpdateThirdInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 机构相关接口
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/backstageOrganization")
public interface BackstageOrganizationServiceApi {
  /**
   * 新增机构信息
   */
  @RequestMapping(value = "addBackstageOrganization", method = {RequestMethod.POST})
  public DubboResult addBackstageOrganization(@RequestBody BackstageOrganizationAddReqDTO req);

  /**
   * 编辑机构信息
   */
  @RequestMapping(value = "updateBackstageOrganization", method = {RequestMethod.POST})
  public DubboResult updateBackstageOrganization(@RequestBody BackstageOrganizationUpdateReqDTO req);


  /**
   * 查询机构信息
   * 
   * @param BackstageOrganizationSearchReqDTO
   */
  @RequestMapping(value = "searchBackstageOrganization", method = {RequestMethod.POST})
  public DubboResult<BackstageOrganizationResDTO> searchBackstageOrganization(
      @RequestBody BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息 列表
   * 
   * @param BackstageOrganizationListReqDTO
   */
  @RequestMapping(value = "listBackstageOrganization", method = {RequestMethod.POST})
  public DubboResult<PageInfo<BackstageOrganizationResDTO>> listBackstageOrganization(
      @RequestBody BackstageOrganizationListReqDTO req);

  /**
   * 更新机构状态
   */
  @RequestMapping(value = "updateBackstageOrganizationStatus", method = {RequestMethod.POST})
  public DubboResult updateBackstageOrganizationStatus(@RequestParam(name = "orgId") Long orgId,
      @RequestBody StatusEnum status);


  /**
   * 查询机构信息
   */
  @RequestMapping(value = "searchBackstageThirdOrg", method = RequestMethod.GET)
  public DubboResult<BackstageOrganizationResDTO> searchBackstageThirdOrg(
      @RequestParam("thirdType") String thirdType, @RequestParam("thirdId") String thirdId);

  /**
   * 编辑机构第三方关联信息
   */
  @RequestMapping(value = "updateOrgThirdInfo", method = {RequestMethod.POST})
  public DubboResult updateOrgThirdInfo(@RequestBody BackstageOrgUpdateThirdInfoReqDTO req);

}
