package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserNoRoleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserNoRoleListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserNoRoleSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserNoRoleUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserNoRoleInfoResDTO;

/**
 * 工作人员相关接口-
 * @see 用户没有角色概念的场景
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/backstageUserNoRole")
public interface BackstageUserNoRoleServiceApi {
  /**
   * 添加工作人员
   */
  @RequestMapping(value = "insertBackstageUser", method = {RequestMethod.POST})
  DubboResult insertBackstageUser(@RequestBody BackstageUserNoRoleAddReqDTO req);

  /**
   * 修改工作人员
   */
  @RequestMapping(value = "updateBackstageUser", method = {RequestMethod.POST})
  DubboResult updateBackstageUser(@RequestBody BackstageUserNoRoleAddReqDTO req);

  /**
   * 查询工作人员
   */
  @RequestMapping(value = "searchBackstageUser", method = {RequestMethod.POST})
  DubboResult<BackstageUserNoRoleInfoResDTO> searchBackstageUser(@RequestBody BackstageUserNoRoleSearchReqDTO req);

  /**
   * 更新工作人员状态-禁用或启用
   */
  @RequestMapping(value = "updateBackstageUserStatus", method = {RequestMethod.POST})
  DubboResult updateBackstageUserStatus(@RequestBody BackstageUserNoRoleUpdateStatusReqDTO req);

  /**
   * 工作人员列表
   */
  @RequestMapping(value = "listBackstageUser", method = {RequestMethod.POST})
  DubboResult<PageInfo<BackstageUserNoRoleInfoResDTO>> listBackstageUser(@RequestBody BackstageUserNoRoleListReqDTO req);
}
