package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SaveScavengerLoginUserInfoReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;

/**
 * 工作人员相关接口
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/backstageUser")
public interface BackstageUserServiceApi {
  /**
   * 添加工作人员
   */
  @RequestMapping(value = "insertBackstageUser", method = {RequestMethod.POST})
  DubboResult<String> insertBackstageUser(@RequestBody BackstageUserAddReqDTO backstageUserAddReqDTO);

  /**
   * 修改工作人员
   */
  @RequestMapping(value = "updateBackstageUser", method = {RequestMethod.POST})
  DubboResult updateBackstageUser(@RequestBody BackstageUserAddReqDTO backstageuserAddReqDTO);

  /**
   * 查询工作人员
   */
  @RequestMapping(value = "searchBackstageUser", method = {RequestMethod.POST})
  DubboResult<BackstageUserInfoResDTO> searchBackstageUser(@RequestBody BackstageUserSearchReqDTO backstageUserSearchReqDTO);

  /**
   * 更新工作人员状态-禁用或启用
   */
  @RequestMapping(value = "updateBackstageUserStatus", method = {RequestMethod.POST})
  DubboResult updateBackstageUserStatus(@RequestBody BackstageUserUpdateStatusReqDTO req);

  /**
   * 工作人员列表
   */
  @RequestMapping(value = "listBackstageUser", method = {RequestMethod.POST})
  DubboResult<PageInfo<BackstageUserInfoResDTO>> listBackstageUser(@RequestBody BackstageUserListReqDTO backstageUserListReqDTO);
  
  /**
   * 重置默认密码
   */
  @RequestMapping(value = "resetDefaultPassword", method = {RequestMethod.POST})
  DubboResult resetDefaultPassword(@RequestParam(name = "userId") Long userId);
  
  /**
   * 环资项目-更新当前登录用户个人资料
   */
  @RequestMapping(value = "updateScavengerLoginUserInfo", method = {RequestMethod.POST})
  DubboResult updateScavengerLoginUserInfo(@RequestBody SaveScavengerLoginUserInfoReqDTO req);
}
