package com.beiming.odr.user.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.AddCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentSingleReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityCycleListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityTemplateListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CapacityTemplateSingleReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DelCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ModCapacityTemplateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.WorkerCenterReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CapacityAssessmentResDTO;
import com.beiming.odr.user.api.dto.responsedto.CapacityCycleDateResDTO;
import com.beiming.odr.user.api.dto.responsedto.CapacityTemplateResDTO;
import com.beiming.odr.user.api.dto.responsedto.WorkerCenterResDTO;

/**
 * 能力评估接口
 * @author ljf
 *
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/capacityAssessment")
public interface CapacityAssessmentApi {

  /**
   * 分页查询模板
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selCapacityTemplatePageList", method = {RequestMethod.POST})
  DubboResult<PageInfo<CapacityTemplateResDTO>> selCapacityTemplatePageList(@RequestBody @Valid CapacityTemplateListReqDTO arg0);
  /**
   * 查询单个模板
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selTemplateSingle", method = {RequestMethod.POST})
  DubboResult<CapacityTemplateResDTO> selTemplateSingle(@RequestBody @Valid CapacityTemplateSingleReqDTO arg0);
  /**
   * 分页查询能力评估结果
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selCapacityAssessmentPageList", method = {RequestMethod.POST})
  DubboResult<PageInfo<CapacityAssessmentResDTO>> selCapacityAssessmentPageList(@RequestBody @Valid CapacityAssessmentListReqDTO arg0);
  /**
   * 查询单个能力评估结果
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selCapacityAssessmentSingle", method = {RequestMethod.POST})
  DubboResult<CapacityAssessmentResDTO> selCapacityAssessmentSingle(@RequestBody @Valid CapacityAssessmentSingleReqDTO arg0);
  /**
   * 新增模板（
   * @param arg0
   * @return
   */
  @RequestMapping(value = "addCapacityTemplate", method = {RequestMethod.POST})
  DubboResult addCapacityTemplate(@RequestBody @Valid AddCapacityTemplateReqDTO arg0);
  /**
   * 修改模板（被引用过的模板不能修改）
   * @param arg0
   * @return
   */
  @RequestMapping(value = "modCapacityTemplate", method = {RequestMethod.POST})
  DubboResult modCapacityTemplate(@RequestBody @Valid ModCapacityTemplateReqDTO arg0);
  /**
   * 删除模板（逻辑）（被引用过的模板不能删除）
   * @param arg0
   * @return
   */
  @RequestMapping(value = "delCapacityTemplate", method = {RequestMethod.POST})
  DubboResult delCapacityTemplate(@RequestBody @Valid DelCapacityTemplateReqDTO arg0);
  
  /**
   * 个人中心查询我的能力评估
   * 逻辑判断userId是否是管理员
   * @param arg0 userId不能为空
   * @return
   */
  @RequestMapping(value = "getWorkerCenterInfo", method = {RequestMethod.POST})
  DubboResult<WorkerCenterResDTO> getWorkerCenterInfo(@RequestBody @Valid WorkerCenterReqDTO arg0);
  /**
   * 导出数据
   * @param arg0
   * @return
   */
  @RequestMapping(value = "exportCapacityResult", method = {RequestMethod.POST})
  DubboResult<ArrayList<CapacityAssessmentResDTO>> exportCapacityResult(@RequestBody @Valid CapacityAssessmentListReqDTO arg0);
  
  /**
   * 根据适用对象查询评估结果表中已经生成的历史周期
   * 20181207
   * @param type
   * @return
   */
  @RequestMapping(value = "selectHisCycleDateByApplicableObject", method = {RequestMethod.POST})
  DubboResult<ArrayList<CapacityCycleDateResDTO>> selectHisCycleDateByApplicableObject(@RequestBody @Valid CapacityCycleListReqDTO arg0);
}
