package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentTaskListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.ExecutionCapacityAssessmentInitResDTO;
import com.beiming.odr.user.api.dto.responsedto.ExecutionCapacityInitPlusResDTO;
import com.beiming.odr.user.api.dto.responsedto.HandlerCapacityAssessmentInitResDTO;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 能力评估后台跑批功能
 * @author ljf
 *
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/capacityAssessmentTask")
public interface CapacityAssessmentTaskApi {
  /**
   * 执行机构管理员能力评估
   */
  @RequestMapping(value = "executionOrgManageEvaluation", method = {RequestMethod.POST})
  DubboResult<PageInfo<String>> executionOrgManageEvaluation(@RequestBody CapacityAssessmentTaskListReqDTO req);
  /**
   * 执行机构/调解员能力评估
   */
  @RequestMapping(value = "executionEvaluation", method = {RequestMethod.POST})
  DubboResult<PageInfo<String>> executionEvaluation(@RequestBody CapacityAssessmentTaskListReqDTO req);
  /**
   * 能力评估完成需要将数据转移到目标表
   * @param req
   * @return
   */
  @RequestMapping(value = "executionEvaluationComplete", method = {RequestMethod.POST})
  DubboResult<Integer> executionEvaluationComplete(@RequestBody CapacityAssessmentTaskListReqDTO req);
  /**
   * 执行初始化语句初始化机构评估数据
   * 响应机构的数量
   * @return
   */
  @RequestMapping(value = "executionOrgInitData", method = {RequestMethod.POST})
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionOrgInitData();
  /**
   * 执行初始化语句初始化机构管理员评估数据
   * 响应机构管理员的数量
   * @return
   */
  @RequestMapping(value = "executionOrgManageInitData", method = {RequestMethod.POST})
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionOrgManageInitData();
  /**
   * 执行初始化语句初始化调解员评估数据
   * 响应需要调解员的数量
   * @return
   */
  @RequestMapping(value = "executionMediationInitData", method = {RequestMethod.POST})
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionMediationInitData();

  /**
   * 执行初始化语句初始化处置员评估数据
   * 响应需要处置员的数量
   * @return
   */
  @RequestMapping(value = "executionHandlerInitData", method = {RequestMethod.POST})
  DubboResult<HandlerCapacityAssessmentInitResDTO> executionHandlerInitData();

  /**
   * 增强的org能力评估
   *
   */
  @RequestMapping(value = "executionOrgInitPlusData", method = {RequestMethod.POST})
  DubboResult<ExecutionCapacityInitPlusResDTO> executionOrgInitPlusData();

}
