package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.MenuInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.MenuInfoReqDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/commonMenuConfig")
public interface CommonMenuConfigServiceApi {
  /** 新增菜单 */
  @RequestMapping(value = "insertMenuInfo", method = {RequestMethod.POST})
  DubboResult insertMenuInfo(@RequestBody MenuInfoReqDTO menuInfoRequestDTO);

  /** 获取菜单信息 */
  @RequestMapping(value = "getMenuInfo", method = {RequestMethod.POST})
  DubboResult<MenuInfoDTO> getMenuInfo(@RequestParam(name = "menuId") Long menuId);

  /** 获取菜单列表 */
  @RequestMapping(value = "listMenuInfo", method = {RequestMethod.POST})
  DubboResult<PageInfo<MenuInfoDTO>> listMenuInfo(@RequestBody MenuInfoReqDTO menuInfoRequestDTO);

  /** 更新菜单 */
  @RequestMapping(value = "updateMenuInfo", method = {RequestMethod.POST})
  DubboResult updateMenuInfo(@RequestBody MenuInfoReqDTO menuInfoRequestDTO);

  /** 删除菜单 */
  @RequestMapping(value = "deleteMenuInfo", method = {RequestMethod.POST})
  DubboResult deleteMenuInfo(@RequestParam(name = "menuId") Long menuId);

  /**
   * 获取菜单列表，用于给角色管理权限
   */
  @RequestMapping(value = "listMenuInfoToRole", method = {RequestMethod.POST})
  DubboResult<PageInfo<MenuInfoDTO>> listMenuInfoToRole();
}
