package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.MediatorListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.MediatorListResDTO;
import com.beiming.odr.user.api.page.PageResult;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/counselorAndMediator")
public interface CounselorAndMediatorServiceApi {

  /**
   * 获取调解员列表分页
   * @param mediatorListRequestDTO
   * @return
   */
  @RequestMapping(value = "getMediatorListPage", method = {RequestMethod.POST})
  public PageResult<MediatorListResDTO> getMediatorListPage(@RequestBody MediatorListReqDTO mediatorListRequestDTO);

}
