package com.beiming.odr.user.api;


import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;

/**
 * 字典
 * 
 * @author fhs
 * @date 2018年6月13日
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/dictionary")
public interface DictionaryServiceApi {

  /**
   * 根据parentCode 查询字典项
   * 
   * @param parentCode
   * @param code
   */
  @RequestMapping(value = "searchDictionaryInfo", method = {RequestMethod.POST})
  public DubboResult<DictionaryResDTO> searchDictionaryInfo(@RequestBody DictionaryReqDTO dictionaryReqDTO);
  
  /**
   * 根据parentCode 查询字典树
   */
  @RequestMapping(value = "searchDictionaryTree", method = {RequestMethod.POST})
  public DubboResult<DictionaryResDTO> searchDictionaryTree(@RequestBody DictionaryReqDTO dictionaryReqDTO);


  /** 新增字典信息 */
  @RequestMapping(value = "insertDictionary", method = {RequestMethod.POST})
  public DubboResult insertDictionary(@RequestBody DictionaryReqDTO dictionaryReqDTO);

  /*** 查询字典信息 */
  @RequestMapping(value = "searchDictionary", method = {RequestMethod.POST})
  public DubboResult<DictionaryInfoDTO> searchDictionary(@RequestParam(name = "dictionaryId") Long dictionaryId);

  /** 字典列表 */
  @RequestMapping(value = "listDictionary", method = {RequestMethod.POST})
  public DubboResult<PageInfo<DictionaryInfoDTO>> listDictionary(@RequestBody DictionaryReqDTO dictionaryReqDTO);

  /** 更新字典 */
  @RequestMapping(value = "updateDictionary", method = {RequestMethod.POST})
  public DubboResult updateDictionary(@RequestBody DictionaryReqDTO dictionaryReqDTO);

  /** 删除字典 */
  @RequestMapping(value = "deleteDictionary", method = {RequestMethod.POST})
  public DubboResult deleteDictionary(@RequestParam(name = "dictionaryId") Long dictionaryId);
  
  /** 通过父级代码数组查询字典信息 */
  @RequestMapping(value = "getDictionaryByParentCode", method = {RequestMethod.POST})
  public DubboResult<DictionaryResDTO> getDictionaryByParentCode(@RequestParam(name = "parentCodes") List<String> parentCodes);

  /*** 查询字典信息 */
  @RequestMapping(value = "searchDictionaryByCode", method = {RequestMethod.POST})
  public DubboResult<DictionaryInfoDTO> searchDictionaryByCode(@RequestParam(name = "code") String code);

}
