package com.beiming.odr.user.api;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorSearchReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DisputeTypeEarlyWarningMonitorInfoResDTO;

/**
 * 纠纷类型预警监控相关接口
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/disputeTypeEarlyWarningMonitor")
@Valid
public interface DisputeTypeEarlyWarningMonitorServiceApi {
  /**
   * 添加纠纷类型预警监控
   */
  @RequestMapping(value = "insertData", method = {RequestMethod.POST})
  DubboResult insertData(@RequestBody @Valid DisputeTypeEarlyWarningMonitorAddReqDTO request);

  /**
   * 修改纠纷类型预警监控
   */
  @RequestMapping(value = "updateData", method = {RequestMethod.POST})
  DubboResult updateData(@RequestBody @Valid DisputeTypeEarlyWarningMonitorAddReqDTO request);

  /**
   * 查询纠纷类型预警监控
   */
  @RequestMapping(value = "searchData", method = {RequestMethod.POST})
  DubboResult<DisputeTypeEarlyWarningMonitorInfoResDTO> searchData(
      @RequestBody @Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 删除数据
   */
  @RequestMapping(value = "deleteData", method = {RequestMethod.POST})
  DubboResult deleteData(@RequestBody @Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 暂停或者启用-状态相互切换
   */
  @RequestMapping(value = "updateSuspendFlagData", method = {RequestMethod.POST})
  DubboResult updateSuspendFlagData(@RequestBody @Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 纠纷类型预警监控列表
   */
  @RequestMapping(value = "listData", method = {RequestMethod.POST})
  DubboResult<PageInfo<DisputeTypeEarlyWarningMonitorInfoResDTO>> listData(
      @RequestBody @Valid DisputeTypeEarlyWarningMonitorListReqDTO request);
}
