package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.GdsfrzAccessTokenDTO;
import com.beiming.odr.user.api.dto.GdsfrzUserobjDTO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 广东统一认证
 *
 * @author jiangyanfeng
 * @date 2019年12月18日
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/gdtyrz")
public interface GdtyrzServiceApi {

  /** 获取accessToken */
  @RequestMapping(value = "getAccessToken", method = {RequestMethod.POST})
  DubboResult<GdsfrzAccessTokenDTO> getAccessToken(@RequestParam(name = "code") String code, @RequestParam(name = "redirectUri") String redirectUri);

  /** 获取用户信息 */
  @RequestMapping(value = "getUserobj", method = {RequestMethod.POST})
  DubboResult<GdsfrzUserobjDTO> getUserobj(@RequestParam(name = "accessToken") String accessToken);

  /** 通过小程序登录获取用户信息 */
  @RequestMapping(value = "getUserobjByApp", method = {RequestMethod.POST})
  DubboResult<GdsfrzUserobjDTO> getUserobjByApp(@RequestParam(name = "token") String token);

}
