package com.beiming.odr.user.api;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.UserImportTempReqDTO;

/**
 * 导入数据api
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/importData")
public interface ImportDataServiceApi {

  /** 检查导入的数据的信息 */
  @RequestMapping(value = "checkImportUserData", method = {RequestMethod.POST})
  DubboResult checkImportUserData(@RequestBody List<UserImportTempReqDTO> requestDTO);
  
  /** 导入用户数据 */
  @RequestMapping(value = "importUserData", method = {RequestMethod.POST})
  DubboResult importUserData(@RequestBody List<UserImportTempReqDTO> requestDTO);
  
  
}
