package com.beiming.odr.user.api;

import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.LeaderSchedulePageListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.QueryUserIdLeaderListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SaveLeaderScheduleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LeaderSchedulePageListResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/leaderSchedule")
public interface LeaderScheduleServiceApi {
  
  /** 保存领导排班 */
  @RequestMapping(value = "saveLeaderSchedule", method = {RequestMethod.POST})
  DubboResult saveLeaderSchedule(@RequestBody List<SaveLeaderScheduleReqDTO> reqs);
  
  /** 删除领导排班 */
  @RequestMapping(value = "deleteLeaderSchedule", method = {RequestMethod.POST})
  DubboResult deleteLeaderSchedule(@RequestBody CommonIdReqDTO req);
  
  
  /** 领导排班列表 */
  @RequestMapping(value = "getLeaderSchedulePageList", method = {RequestMethod.POST})
  DubboResult<PageInfo<LeaderSchedulePageListResDTO>> getLeaderSchedulePageList(@RequestBody LeaderSchedulePageListReqDTO req);

  /** 通过用户领导排班列表 */
  @RequestMapping(value = "queryUserIdLeaderList", method = {RequestMethod.POST})
  DubboResult<ArrayList<LeaderSchedulePageListResDTO>> queryUserIdLeaderList(
      @RequestBody QueryUserIdLeaderListReqDTO req);

}
