package com.beiming.odr.user.api;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.DisputeReportReqDTO;
import com.beiming.odr.user.api.dto.responsedto.MapDisputeResDTO;

/**
 * 地图纠纷统计报表
 * @author zhiguang
 *
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/mapDisputeStatistics")
public interface MapDisputeStatisticsServiceApi {
  
  /**
   * 获取地图纠纷统计数据
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "getMapDisputeStatistics", method = {RequestMethod.POST})
  public DubboResult<MapDisputeResDTO> getMapDisputeStatistics(@RequestBody List<DisputeReportReqDTO> reqDTOs);

}
