package com.beiming.odr.user.api;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.AddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.ListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.SearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.UpdatePublishStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.UpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.NewsInformationResDTO;

/**
 * 新闻
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/newsInformation")
@Valid
public interface NewsInformationServiceApi {
  /**
   * 添加新闻内容
   */
  @RequestMapping(value = "addData", method = {RequestMethod.POST})
  DubboResult addData(@RequestBody @Valid AddReqDTO addReqDTO);

  /**
   * 修改新闻内容
   */
  @RequestMapping(value = "updateData", method = {RequestMethod.POST})
  DubboResult updateData(@RequestBody @Valid UpdateReqDTO updateReqDTO);

  /**
   * 查询新闻内容-后端
   * @see 不需要查询上一页和下一页的数据
   */
  @RequestMapping(value = "searchData", method = {RequestMethod.POST})
  DubboResult<NewsInformationResDTO> searchData(@RequestBody @Valid SearchReqDTO searchReqDTO);
  
  /**
   * 查询新闻内容-前段
   * @see 需要查询上一页和下一页的数据
   */
  @RequestMapping(value = "frontSearchData", method = {RequestMethod.POST})
  DubboResult<NewsInformationResDTO> frontSearchData(@RequestBody @Valid SearchReqDTO searchReqDTO);

  /**
   * 更新新闻发布状态
   */
  @RequestMapping(value = "updatePublishStatus", method = {RequestMethod.POST})
  DubboResult updatePublishStatus(@RequestBody @Valid UpdatePublishStatusReqDTO updateReqDTO);

  /**
   * 新闻列表
   */
  @RequestMapping(value = "listData", method = {RequestMethod.POST})
  DubboResult<PageInfo<NewsInformationResDTO>> listData(@RequestBody @Valid ListReqDTO listReqDTO);
}
