package com.beiming.odr.user.api;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrdinaryUserInfoResDTO;

/**
 * 普通用户相关接口
 * 
 * @author fanheshui
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/ordinaryUser")
@Valid
public interface OrdinaryUserServiceApi {
  /**
   * 添加普通用户
   */
  @RequestMapping(value = "insertOrdinaryUser", method = {RequestMethod.POST})
  DubboResult insertOrdinaryUser(@RequestBody @Valid OrdinaryUserAddReqDTO ordinaryUserAddReqDTO);

  /**
   * 查询普通用户
   */
  @RequestMapping(value = "searchOrdinaryUser", method = {RequestMethod.POST})
  DubboResult<OrdinaryUserInfoResDTO> searchOrdinaryUser(
      @RequestBody @Valid OrdinaryUserSearchReqDTO ordinaryUserSearchReqDTO);


  /**
   * 修改普通用户
   */
  @RequestMapping(value = "updateOrdinaryUser", method = {RequestMethod.POST})
  DubboResult updateOrdinaryUser(@RequestBody @Valid OrdinaryUserUpdateReqDTO ordinaryUserUpdateReqDTO);


  /**
   * 普通用户列表
   */
  @RequestMapping(value = "listOrdinaryUser", method = {RequestMethod.POST})
  DubboResult<PageInfo<OrdinaryUserInfoResDTO>> listOrdinaryUser(
      @RequestBody @Valid  OrdinaryUserListReqDTO ordinaryUserListReqDTO);
  
  /**
   * 查询普通用户-新版
   */
  @RequestMapping(value = "searchOrdinaryUserNew", method = {RequestMethod.POST})
  DubboResult<OrdinaryUserInfoResDTO> searchOrdinaryUserNew(
      @RequestBody @Valid OrdinaryUserSearchReqDTO ordinaryUserSearchReqDTO);
  
  /**
   * 普通用户列表-新版
   */
  @RequestMapping(value = "listOrdinaryUserNew", method = {RequestMethod.POST})
  DubboResult<PageInfo<OrdinaryUserInfoResDTO>> listOrdinaryUserNew(
      @RequestBody @Valid  OrdinaryUserListReqDTO ordinaryUserListReqDTO);
}
