package com.beiming.odr.user.api;

import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.OrgDataImportBean;
import com.beiming.odr.user.api.dto.requestdto.OrgDataCheckReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgDataCheckResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/orgDataInport")
public interface OrgDataInportApi {
  /**
   * <pre>
   * @. 批量机构数据导入--检查
   * @. 检查通过响应合法数据
   * </pre>
   * @param reqdto
   * @return
   */
  @RequestMapping(value = "orgDataCheck", method = {RequestMethod.POST})
  public DubboResult<OrgDataCheckResDTO> orgDataCheck(@RequestBody OrgDataCheckReqDTO reqdto);
  /**
   * <pre>
   * @. 批量机构数据导入--检查
   * @. 检查通过响应合法数据
   * </pre>
   * @param reqdto
   * @return
   */
  @RequestMapping(value = "orgDataImport", method = {RequestMethod.POST})
  public DubboResult orgDataImport(@RequestBody ArrayList<OrgDataImportBean> reqdto);
}
