package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.*;
import com.beiming.odr.user.api.dto.responsedto.*;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;


@RestController
@RequestMapping(UserConst.URL_PREFIX + "/organization")
public interface OrganizationServiceApi {
  
  /**
   * 智能推荐调解机构
   * @param recommendOrganizationReqDTO
   * @return
   */
  @RequestMapping(value = "getRecommendOrganization", method = {RequestMethod.POST})
  public DubboResult<OrganizationResDTO> getRecommendOrganization(@RequestBody RecommendOrganizationReqDTO recommendOrganizationReqDTO);

  /**
   * 选择调解机构列表分页
   * @param organizationListReqDTO
   * @return
   */
  @RequestMapping(value = "getMediateOrganizationListPage", method = {RequestMethod.POST})
  public DubboResult<PageInfo<OrganizationResDTO>> getMediateOrganizationListPage(@RequestBody OrganizationListReqDTO organizationListReqDTO);
  
  /**
   * 获取机构列表分页
   * @param getOrganizationPageRequestDTO
   * @return
   */
  @RequestMapping(value = "getOrganizationListPage", method = {RequestMethod.POST})
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPage(@RequestBody OrganizationListReqDTO organizationListReqDTO);
  
  /**
   * 推荐机构列表根据调解员数量倒序 limit 5
   * @param currentUserId
   * @return
   */
  @RequestMapping(value = "getOrgListOrderByMediatorNumber", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrgListOrderByMediatorNumberResDTO>> getOrgListOrderByMediatorNumber(@RequestParam(name = "disputeTypeCode") String disputeTypeCode, @RequestParam(name = "currentUserId") String currentUserId);

  /**
   * 获取机构详情
   * @param orgId
   * @return
   */
  @RequestMapping(value = "getOrganizationDetail", method = {RequestMethod.POST})
  public DubboResult<OrganizationResDTO> getOrganizationDetail(@RequestParam(name = "orgId") Long orgId);
  
  /**
   * 查询机构下服务人员的数量
   * @param orgId
   * @return
   */
  @RequestMapping(value = "getServicePersonNumber", method = {RequestMethod.POST}, params = {"orgIds"})
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(@RequestBody List<Long> orgIds);
  
  /**
   * 查询机构下服务人员的数量
   * @param orgId
   * @return
   */
  @RequestMapping(value = "getServicePersonNumber", method = {RequestMethod.POST})
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(@RequestBody List<Long> orgIds, 
      @RequestParam(name = "currentUserId", required = false) String currentUserId);
  
  /**
   * 查询首页统计数据
   * @return
   */
  @RequestMapping(value = "getHomeDataCount", method = {RequestMethod.POST})
  public DubboResult<HomeDataCountResDTO> getHomeDataCount();
  
  /**
   * 查询机构总数量
   * @return
   */
  @RequestMapping(value = "getAllOrganizationCount", method = {RequestMethod.POST})
  public DubboResult<Integer> getAllOrganizationCount();
  
  /**
   * 得到机构管理员所在的机构id
   */
  @RequestMapping(value = "getOrgIdByOrgManageUser", method = {RequestMethod.POST})
  DubboResult<Long> getOrgIdByOrgManageUser(@RequestParam(name = "userId") Long userId);
  
  /**
   * 通过机构管理员或区域管理员id获取所在区域
   * @param userId
   * @return
   */
  @RequestMapping(value = "getAreaCodeByManageUserId", method = {RequestMethod.POST})
  public DubboResult<String> getAreaCodeByManageUserId(@RequestParam(name = "manageUserId") Long manageUserId);
  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   * @param arg0
   * @return
   */
  @RequestMapping(value = "getOrgSingleInfoList", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoList(@RequestBody @Valid SelOrgInfoSingleReqDTO arg0);
  /**
   * <pre>
   * 传入调解员或机构管理员的userId查询其绑定的所以机构的简易信息
   * @param arg0
   * @return
   */
  @RequestMapping(value = "getOrgSingleInfoByUserId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoByUserId(@RequestParam(name = "userId") String userId);
  
  /**
   * 根据机构id和要查询的角色类型，返回对应的角色类型的用户详情
   * 
   * @param orgId 机构id
   * @param roleTypeEnumList 角色类型列表
   */
  @RequestMapping(value = "getUserInfoByOrgIdAndRoleType", method = {RequestMethod.POST})
  public DubboResult<ArrayList<UserInfoDTO>> getUserInfoByOrgIdAndRoleType(@RequestParam(name = "orgId") Long orgId,
      @RequestBody List<RoleTypeEnum> roleTypeEnumList);
  
  /**
   * 查询用户所在机构，本级及父级
   * @param userId
   * @return
   */
  @RequestMapping(value = "getOrganizationListByUserId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getOrganizationListByUserId(@RequestParam(name = "userId") Long userId);
  /**
   * 查询阳光信访机构信息
   * @return
   */
  @RequestMapping(value = "getOrganizationYgxfList", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationYgxfResDTO>> getOrganizationYgxfList();

  /**
   * 查询用户所在机构，本级及以下子级
   * @param userId
   * @return
   */
  @RequestMapping(value = "getLowerOrganizationListByUserId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getLowerOrganizationListByUserId(@RequestParam(name = "userId") Long userId);
  
  /**
   * 通过工单类型和区域查询机构
   */
  @RequestMapping(value = "getOrganizationByAppealOrgType", method = {RequestMethod.POST})
  public DubboResult<OrganizationResDTO> getOrganizationByAppealOrgType(@RequestBody @Valid AppealOrgTypeAndAreaCodeReqDTO appealOrgTypeAndAreaCodeReqDTO);
  
  /**
   * 获取诉求机构列表分页
   * @param getOrganizationPageRequestDTO
   * @return
   */
  @RequestMapping(value = "getAppealOrganizationListPage", method = {RequestMethod.POST})
  public DubboResult<PageInfo<OrganizationResDTO>> getAppealOrganizationListPage(@RequestBody AppealOrganizationListReqDTO appealOrganizationListReqDTO);

  /**
   * 获取转办机构
   */
  @RequestMapping(value = "getTransferOrgList", method = {RequestMethod.POST})
  public DubboResult<PageInfo<TransferOrgResDTO>> getTransferOrgList(@RequestBody TransferOrgReqDTO reqDTO);

  /**
   * 根据用户id查询所属机构
   * @param userId
   * @return
   */
  @RequestMapping(value = "getOrganizationByUserId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getOrganizationByUserId(@RequestParam(name = "userId") Long userId);

  /**
   * 根据用户id查询所属机构及下属机构
   * @param userId
   * @return
   */
  @RequestMapping(value = "getAvailableOrganizationByUserId", method = {RequestMethod.POST})
  public DubboResult<ArrayList<OrganizationResDTO>> getAvailableOrganizationByUserId(@RequestParam(name = "userId") Long userId);
}
