package com.beiming.odr.user.api;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.RoleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleDeleteReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.GetOrganizationsByRoleCodeResDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResListDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/role")
public interface RoleServiceApi {
  /**
   * 角色的新增
   */
  @RequestMapping(value = "insertRole", method = {RequestMethod.POST})
  DubboResult insertRole(@RequestBody RoleAddReqDTO roleAddReqDTO);

  /**
   * 角色的修改
   */
  @RequestMapping(value = "updateRole", method = {RequestMethod.POST})
  DubboResult updateRole(@RequestBody RoleUpdateReqDTO roleUpdateReqDTO);

  /**
   * 角色列表
   */
  @RequestMapping(value = "listRole", method = {RequestMethod.POST})
  DubboResult<PageInfo<RoleInfoResDTO>> listRole(@RequestBody RoleListReqDTO roleListReqDTO);

  /**
   * 获取角色信息
   */
  @RequestMapping(value = "getRoleCode", method = {RequestMethod.POST})
  DubboResult<RoleInfoResDTO> getRoleCode(@RequestBody RoleSearchReqDTO roleSearchReqDTO);

  /**
   * 角色删除
   */
  @RequestMapping(value = "deleteRole", method = {RequestMethod.POST})
  DubboResult deleteRole(@RequestBody RoleDeleteReqDTO roleDeleteReqDTO);

  /**
   * 查询工作人员角色
   */
  @RequestMapping(value = "searchWorkUserRole", method = {RequestMethod.POST})
  DubboResult<RoleInfoResListDTO> searchWorkUserRole(@RequestBody RoleSearchReqDTO roleSearchReqDTO);

  /***
   * 通过角色代码集合查询关联机构信息
   */
  @RequestMapping(value = "getOrganizationsByRoleCodes", method = {RequestMethod.POST})
  public DubboResult<GetOrganizationsByRoleCodeResDTO> getOrganizationsByRoleCodes(
      @RequestParam(name = "roleCodes") List<String> roleCodes);
}
