package com.beiming.odr.user.api;

import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.ScavengerStatisticsDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/scavengerStatistics")
public interface ScavengerStatisticsServiceApi {
  /**
   * 查询人员数量统计
   */
  @RequestMapping(value = "userStatistics", method = {RequestMethod.POST})
  public DubboResult<ArrayList<ScavengerStatisticsDTO>> userStatistics();
  
  /**
   * 查询机构数量统计
   */
  @RequestMapping(value = "orgTypeStatistics", method = {RequestMethod.POST})
  public DubboResult<ArrayList<ScavengerStatisticsDTO>> orgTypeStatistics();
  
}
