package com.beiming.odr.user.api;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.AddServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqByMobileDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonUpdateRoleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.beiming.odr.user.api.dto.responsedto.SerchServicePersonGrantAuthInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;

/**
 * 服务人员相关接口
 * 
 * @author
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/servicePerson")
@Valid
public interface ServicePersonServiceApi {

  /**
   * 机构管理员-添加服务人员
   */
  @RequestMapping(value = "addServicePerson", method = {RequestMethod.POST})
  public DubboResult addServicePerson(@RequestBody AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员详细信息
   */
  @RequestMapping(value = "searchServicePerson", method = {RequestMethod.POST})
  public DubboResult<SearchServicePersonResDTO> searchServicePerson(
      @RequestBody SearchServicePersonReqDTO req);

  /**
   * 机构管理员-编辑服务人员
   */
  @RequestMapping(value = "updateServicePerson", method = {RequestMethod.POST})
  DubboResult updateServicePerson(@RequestBody AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员授权信息
   */
  @RequestMapping(value = "serchServicePersonGrantAuthInfo", method = {RequestMethod.POST})
  DubboResult<SerchServicePersonGrantAuthInfoResDTO> serchServicePersonGrantAuthInfo(@RequestParam(name = "userId") Long userId);

  /**
   * 查询服务人员详细信息-通过手机号码
   */
  @RequestMapping(value = "searchServicePersonByMobile", method = {RequestMethod.POST})
  DubboResult<SearchServicePersonResDTO> searchServicePersonByMobile(
      @RequestBody SearchServicePersonReqByMobileDTO req);

  /**
   * 机构管理员-更新服务人员权限
   */
  @RequestMapping(value = "updateServicePersonRole", method = {RequestMethod.POST})
  DubboResult updateServicePersonRole(
      @RequestBody @Valid ServicePersonUpdateRoleReqDTO request);
  
  /**
   * 通过用户名称、角色类型查询服务人员分页
   * @param userName
   * @param roleType
   * @return
   */
  @RequestMapping(value = "getServicePersonByUserNameAndRoleType", method = {RequestMethod.POST})
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonByUserNameAndRoleType(@RequestParam(name = "userName") String userName, @RequestBody RoleTypeEnum roleType);

}
