package com.beiming.odr.user.api;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.ExportTemplateFileReqDTO;
import com.beiming.odr.user.api.dto.responsedto.ExportTemplateFileResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/templateFileExport")
@Valid
public interface TemplateFileExportApi {

  /**
   *  导出机构数据导入的模板文件
   * 根据应用名称获取模板,如果没有则马上创建一个模板
   * @param addServicePersonReqDTO
   * @return
   */
  @RequestMapping(value = "exportOrgDataImportTemplateFile", method = {RequestMethod.POST})
  DubboResult<ExportTemplateFileResDTO> exportOrgDataImportTemplateFile(@RequestBody ExportTemplateFileReqDTO reqDto);
  /**
   *  导出用户数据导入的模板文件
   * 根据应用名称获取模板,如果没有则马上创建一个模板
   * @param addServicePersonReqDTO
   * @return
   */
  @RequestMapping(value = "exportUserDataImportTemplateFile", method = {RequestMethod.POST})
  DubboResult<ExportTemplateFileResDTO> exportUserDataImportTemplateFile();


}
