package com.beiming.odr.user.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.TrainingCataloguesReqDTO;
import com.beiming.odr.user.api.dto.responsedto.TrainingCataloguesResDTO;


/**
 * 培训附件API
 * 
 * @author qsh
 * @data 2018年10月16日
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/trainingCatalogues")
public interface TrainingCataloguesApi {
  /**
   * 查询附近信息
   * 
   * @return
   */
  @RequestMapping(value = "queryTrainingAttachmentList", method = {RequestMethod.POST})
  DubboResult<PageInfo<TrainingCataloguesResDTO>> queryTrainingAttachmentList(
      @RequestBody TrainingCataloguesReqDTO trainingCataloguesReqDTO);

}
