package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserAccountMapSaveDTO;
import com.beiming.odr.user.api.dto.responsedto.UserAccountMapResDTO;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userAccountMap")
public interface UserAccountMapServiceApi {

  @RequestMapping(value = "saveUserAccountMap", method = {RequestMethod.POST})
  DubboResult saveUserAccountMap(@RequestBody UserAccountMapSaveDTO reqDTO);

  @RequestMapping(value = "selectUserAccountMapByUserId", method = {RequestMethod.POST})
  DubboResult<UserAccountMapResDTO> selectUserAccountMapByUserId(@RequestBody CommonIdReqDTO reqDTO);

}
