package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.UserActionLogConsumerReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserActionLogListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.UserActionLogListResDTO;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userActionLog")
public interface UserActionLogServiceApi {

  @RequestMapping(value = "insertUserActionLog", method = {RequestMethod.POST})
  DubboResult insertUserActionLog(@RequestBody UserActionLogConsumerReqDTO reqDTO);


  /**
   * 列表查询接口 <br>
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/queryUserActionLog", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<UserActionLogListResDTO>> queryUserActionLog(
      @RequestBody @Valid UserActionLogListReqDTO reqDTO);

}
