package com.beiming.odr.user.api;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.UserEvaluateDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseIsEvaluateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluatePageListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseIsEvaluateResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateResDTO;


@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userEvaluate")
public interface UserEvaluateServiceApi {

  /**
   * 获取用户评价列表
   * @param userEvaluateListRequestDTO
   * @return List<UserEvaluate>
   */
  @RequestMapping(value = "getUserEvaluateList", method = {RequestMethod.POST})
  public DubboResult<UserEvaluateResDTO> getUserEvaluateList(@RequestBody UserEvaluateListReqDTO userEvaluateListReqDTO);
  
  /**
   * 获取用户评价分页列表
   * @param userEvaluatePageListReqDTO
   * @return
   */
  @RequestMapping(value = "getUserEvaluatePageList", method = {RequestMethod.POST})
  public DubboResult<PageInfo<UserEvaluateDTO>> getUserEvaluatePageList(@RequestBody UserEvaluatePageListReqDTO reqDTO);
  
  /**
   * 保存用户评价
   * @param saveUserEvaluateRequestDTO
   * @return
   */
  @RequestMapping(value = "saveUserEvaluate", method = {RequestMethod.POST})
  public DubboResult<Boolean> saveUserEvaluate(@RequestBody UserEvaluateDTO userEvaluateDTO);
  
  /**
   * 查询用户评价数和星星数
   * @param userEvaluateGradeCountReqDTO
   * @return
   */
  @RequestMapping(value = "getUserEvaluateGradeCount", method = {RequestMethod.POST})
  public DubboResult<UserEvaluateGradeCountResDTO> getUserEvaluateGradeCount(@RequestBody UserEvaluateGradeCountReqDTO userEvaluateGradeCountReqDTO);
  
  /**
   * 查询用户评价数和星星数（多用户）
   * @param userEvaluateGradeCountListReqDTO
   * @return
   */
  @RequestMapping(value = "getUserEvaluateGradeCountList", method = {RequestMethod.POST})
  public DubboResult<UserEvaluateGradeCountListResDTO> getUserEvaluateGradeCountList(@RequestBody UserEvaluateGradeCountListReqDTO userEvaluateGradeCountListReqDTO);
  
  /**
   * 案件是否已评价
   * @param caseIsEvaluateReqDTO
   * @return
   */
  @RequestMapping(value = "getCaseIsEvaluate", method = {RequestMethod.POST})
  public DubboResult<CaseIsEvaluateResDTO> getCaseIsEvaluate(@RequestBody CaseIsEvaluateReqDTO caseIsEvaluateReqDTO);
  
  /**
   *  信访代理人是否已评价
   * @param userEvaluateDTOs
   * @return
   */
  @RequestMapping(value = "getPetitionAgentIsEvaluate", method = {RequestMethod.POST})
  public DubboResult<CaseIsEvaluateResDTO> getPetitionAgentIsEvaluate(@RequestBody List<UserEvaluateDTO> userEvaluateDTOs);
}
