package com.beiming.odr.user.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.UserExtInfoReqDTO;
import com.beiming.odr.user.api.dto.responsedto.UserExtInfoResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userExtInfo")
@Valid
public interface UserExtInfoServiceApi {

  /**
   * 保存或更新用户扩展信息
   * 
   * @param userExtInfoReqDTO
   * @return
   * @author djq
   * @date 2019年7月8日
   */
  @RequestMapping(value = "addUserExtInfo", method = {RequestMethod.POST})
  DubboResult<UserExtInfoResDTO> addUserExtInfo(@RequestBody @Valid UserExtInfoReqDTO userExtInfoReqDTO);

  /**
   * 获取用户扩展信息列表
   * 
   * @param userId
   * @return
   * @author djq
   * @date 2019年7月8日
   */
  @RequestMapping(value = "queryUserExtInfo", method = {RequestMethod.POST})
  DubboResult<ArrayList<UserExtInfoResDTO>> queryUserExtInfo(@RequestParam(name = "userId") Long userId);

}
