package com.beiming.odr.user.api;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.dto.requestdto.UserReportReqDTO;
import com.beiming.odr.user.api.dto.responsedto.UserReportResDTO;

/**
 * 用户统计报表
 * @author zhiguang
 *
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userReport")
public interface UserReportServiceApi {
  /**
   * 用户统计报表
   * @param userReportReqDTO
   * @param isFromCache
   * @return
   */
  @RequestMapping(value = "getUserReport", method = {RequestMethod.POST})
  public DubboResult<UserReportResDTO> getUserReport(@RequestBody UserReportReqDTO userReportReqDTO, @RequestParam(name = "isFromCache") boolean isFromCache);

}
