package com.beiming.odr.user.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseEndCheckerRequestDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserResetPasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdatePasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelMediatorSingleInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginByWechatReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginNotPasswordReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseEndCheckerResponseDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.MediatorSingleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserRoleInfoListResDTO;

@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userService")
@Valid
public interface UserServiceApi {

  /**
   * 新增普通用户
   */
  @RequestMapping(value = "insertCommonUser", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> insertCommonUser(
      @RequestBody @Valid CommonUserRegisterReqDTO req);

  /**
   * 用户登录 -可以通过mobile也可以通过loginName
   * 
   * @param mobile
   * @param password
   * @param loginName
   * @param loginType
   */
  @RequestMapping(value = "userLogin", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLogin(@RequestParam(name = "mobile", required = false) String mobile,  @RequestParam(name = "password") String password, @RequestParam(name = "loginName", required = false) String loginName,
      @RequestBody UserLoginTypeEnum loginType);

  /**
   * 更新普通用户
   */
  @RequestMapping(value = "updateCommonUser", method = {RequestMethod.POST})
  DubboResult updateCommonUser(@RequestBody CommonUserUpdateReqDTO req);

  /**
   * 重置登录密码
   * 
   * @param commonUserResetPasswordReqDTO
   */
  @RequestMapping(value = "resetUserPassword", method = {RequestMethod.POST})
  DubboResult resetUserPassword(@RequestBody @Valid CommonUserResetPasswordReqDTO req);

  /**
   * 人脸识别通过-设置
   *
   * @param UserBasicsId 用户ID
   */
  @RequestMapping(value = "setFacialVerify", method = {RequestMethod.POST})
  DubboResult setFacialVerify(@RequestParam(name = "userId") Long userId);


  /** 实名认证-设置 */
  @RequestMapping(value = "setRealNameAuthentication", method = {RequestMethod.POST})
  DubboResult setRealNameAuthentication(@RequestParam(name = "userId") Long userId,
      @RequestBody RealNameAuthenticationReqDTO req);

  /** 查询普通用户的信息 */
  @RequestMapping(value = "searchCommonUser", method = {RequestMethod.POST})
  DubboResult<CommonUserSearchResDTO> searchCommonUser(@RequestBody CommonIdReqDTO req);

  /**
   * 查询服务人员列表分页
   * 
   * @param servicePersonListReqDTO
   * @return
   */
  @RequestMapping(value = "getServicePersonListPage", method = {RequestMethod.POST})
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonListPage(
      @RequestBody ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 案件用户注册接口
   */
  @RequestMapping(value = "caseUserregister", method = {RequestMethod.POST})
  DubboResult<CaseUserRegisterResDTO> caseUserregister(
      @RequestBody @Valid CaseUserRegisterReqDTO req);

  /**
   * 修改密码
   * 
   * @param commonUserUpdatePasswordReqDTO
   */
  @RequestMapping(value = "updatePassword", method = {RequestMethod.POST})
  DubboResult updatePassword(@RequestBody CommonUserUpdatePasswordReqDTO req);

  /**
   * 修改手机号码
   */
  @RequestMapping(value = "updateMobilePhone", method = {RequestMethod.POST})
  DubboResult updateMobilePhone(@RequestParam(name = "userId") Long userId, @RequestParam(name = "mobilePhone") String mobilePhone);

  /**
   * 修改邮箱
   */
  @RequestMapping(value = "updateEmail", method = {RequestMethod.POST})
  DubboResult updateEmail(@RequestParam(name = "userId") Long userId, @RequestParam(name = "email") String email);

  /**
   * 用过手机号码判断用户是否存在
   * 
   * @param mobile 手机号码
   * @param personTypeEnum 人员类型
   * @return true 存在 false 不存在
   */
  @RequestMapping(value = "checkUserByMobile", method = {RequestMethod.POST})
  DubboResult<Boolean> checkUserByMobile(@RequestParam(name = "mobile")  String mobile, @RequestBody PersonTypeEnum personTypeEnum);

  /**
   * 获取用户角色信息
   * 
   * @param userId 用户id
   * @param orgId 机构id
   */
  @RequestMapping(value = "getRoleInfoByUserId", method = {RequestMethod.POST})
  DubboResult<UserRoleInfoListResDTO> getRoleInfoByUserId(@RequestParam(name = "userId") Long userId);
  
  
  /**
   * 获取内部测试用户userId
   * @return
   */
  @RequestMapping(value = "getInternalTestUserId", method = {RequestMethod.POST})
  DubboResult<String> getInternalTestUserId();
  
  /**
   * 保存内部测试用户userId,id以逗号隔开
   * @return
   */
  @RequestMapping(value = "saveInternalTestUserId", method = {RequestMethod.POST})
  DubboResult saveInternalTestUserId(@RequestParam(name = "userId") String userId);
  
  /**
   * 获取内部测试机构id
   * @return
   */
  @RequestMapping(value = "getInternalTestOrgId", method = {RequestMethod.POST})
  DubboResult<String> getInternalTestOrgId();
  
  /**
   * 保存内部测试机构id,id以逗号隔开
   * @return
   */
  @RequestMapping(value = "saveInternalTestOrgId", method = {RequestMethod.POST})
  DubboResult saveInternalTestOrgId(@RequestParam(name = "orgId") String orgId);

  /**
   * 校验姓名和身份证是否匹配
   * 
   * @return
   */
  @RequestMapping(value = "checkRealNameAuthentication", method = {RequestMethod.POST})
  DubboResult<Boolean> checkRealNameAuthentication(@RequestBody RealNameAuthenticationReqDTO req);
  /**
   * 根据区域代码查询下面的所有调解员OR处置员 添加类型type参数
   * 只需要传区域代码
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selMediatorSingleInfoListByAreaCode", method = {RequestMethod.POST})
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListByAreaCode(@RequestBody @Valid SelMediatorSingleInfoReqDTO arg0);

  /**
   * <pre>
   * 根据机构号查询该机构下的所有调解员 or 处置员
   * 只需要传机构代码
   * @param arg0
   * @return
   */
  @RequestMapping(value = "selMediatorSingleInfoListWithOrgManage", method = {RequestMethod.POST})
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListWithOrgManage(@RequestBody @Valid SelMediatorSingleInfoReqDTO arg0);

  /***
   *  删除 用户密码是默认8个8，确已经登录的用户（app和小程序）
   * */
  @RequestMapping(value = "deleteUserLoginToken", method = {RequestMethod.POST})
  DubboResult<ArrayList<Long>> deleteUserLoginToken();
  
  
  /**
   * 用户登录 -无需密码
   * 
   * @param UserLoginNotPasswordReqDTO req
   */
  @RequestMapping(value = "userLoginNotPassword", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLoginNotPassword(@RequestBody UserLoginNotPasswordReqDTO req);
  /**
   * 微信登录，没有则自动注册账号
   * @param req
   * @return
   */
  @RequestMapping(value = "userLoginByWechat", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLoginByWechat(@RequestBody UserLoginByWechatReqDTO req);
  
  /**
   * 通过机构查询服务人员列表
   * 
   * @param servicePersonListReqDTO
   * @return
   */
  @RequestMapping(value = "queryServicePersonList", method = {RequestMethod.POST})
  DubboResult<ArrayList<ServicePersonListResDTO>> queryServicePersonList(
      @RequestBody ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 用户登录 -无需密码
   */
  @RequestMapping(value = "userLoginNotPassword1", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLoginNotPassword1(@RequestParam("mobilePhone") String mobilePhone);
  /**
   * 查询用户是否登录系统标识
   */
  @RequestMapping(value = "queryLoginFlagByUserId", method = {RequestMethod.POST})
  DubboResult<String> queryLoginFlagByUserId(@RequestParam("userId") String userId);
  
  @RequestMapping(value = "queryUserListForCaseEndChecker", method = {RequestMethod.POST})
  DubboResult<CaseEndCheckerResponseDTO> queryUserListForCaseEndChecker(@RequestBody CaseEndCheckerRequestDTO req);

  @RequestMapping(value = "queryLoginAccountByUserId", method = {RequestMethod.POST})
  DubboResult<String> queryLoginAccountByUserId(@RequestParam("userId") String userId);
}
