package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CompanyUserInfoPageReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CompanyUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchRoleUserInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginAndRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginByMicroCourtReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BatchUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CompanyUserInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/***
 * @see 用户api中已经放不下了，特此新建第二个用户api
 */
@RestController
@RequestMapping(UserConst.URL_PREFIX + "/userServiceSecond")
@Valid

public interface UserServiceSecondApi {

  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   * 
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   */
  @RequestMapping(value = "searchAndRegisterByMobileCommon", method = {RequestMethod.POST})
  DubboResult<UserInfoDTO> searchAndRegisterByMobileCommon(@RequestParam(name = "mobilePhone") String mobilePhone, @RequestParam(name = "userName") String userName);

  /**
   * 通过用户id查询用户信息
   * 
   * @param mobilePhone 手机号码
   */
  @RequestMapping(value = "searchUserInfoByUserId", method = {RequestMethod.POST})
  DubboResult<ArrayList<UserInfoDTO>> searchUserInfoByUserId(@RequestParam(name = "list") List<Long> list);

  /**
   * 查询角色用户信息
   * 
   * @param mobilePhone 手机号码
   */
  @RequestMapping(value = "searchRoleUserInfo", method = {RequestMethod.POST})
  DubboResult<UserInfoDTO> searchRoleUserInfo(@RequestBody SearchRoleUserInfoReqDTO param);

  /** 实名认证和人脸识别一起设置 */
  @RequestMapping(value = "setRealNameAndFacialVerify", method = {RequestMethod.POST})
  DubboResult setRealNameAndFacialVerify(@RequestParam(name = "userId") Long userId, @RequestBody RealNameAuthenticationReqDTO requestDTO);

  /**
   * 批量注册 用过手机号码列表
   * 
   * @see 不做数据的任何校验，就做简单的插入。数据校验，调用该接口时，自己校验
   * @param mobilePhone 手机号码
   */
  @RequestMapping(value = "batchUserRegister", method = {RequestMethod.POST})
  DubboResult<ArrayList<BatchUserRegisterResDTO>> batchUserRegister(@RequestParam(name = "list") List<String> list);
  
  /** 查询企业用户的信息 */
  @RequestMapping(value = "searchCompanyUser", method = {RequestMethod.POST})
  DubboResult<CompanyUserInfoResDTO> searchCompanyUser(@RequestBody CommonIdReqDTO commonIdReqDTO);
  
  /** 查询企业用户分页 */
  @RequestMapping(value = "getCompanyUserInfoPage", method = {RequestMethod.POST})
  DubboResult<PageInfo<CompanyUserInfoResDTO>> getCompanyUserInfoPage(@RequestBody CompanyUserInfoPageReqDTO companyUserInfoPageReqDTO);
  /** 审核企业用户 */
  @RequestMapping(value = "approveCompanyUser", method = {RequestMethod.POST})
  DubboResult approveCompanyUser(@RequestParam(name = "userId") Long userId, @RequestBody StatusEnum statusEnum);
  
  /**
   * 新增企业用户
   */
  @RequestMapping(value = "insertCompanyUser", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> insertCompanyUser(@RequestBody @Valid CompanyUserRegisterReqDTO req);
  
  /**
   * 新增普通用户
   */
  @RequestMapping(value = "validateRegisterCompanyUser", method = {RequestMethod.POST})
  DubboResult validateRegisterCompanyUser(@RequestBody @Valid CommonUserRegisterReqDTO req);
  
  /**
   * 是否是新用户
   * @param userId
   * @return true：新用户，false：老用户
   */
  @RequestMapping(value = "isNewUser", method = {RequestMethod.POST})
  DubboResult<Boolean> isNewUser(@RequestParam(name = "userId") Long userId);
  
  /**
   * 更新新用户为旧用户
   * @param userId
   * @return
   */
  @RequestMapping(value = "updateNewUser", method = {RequestMethod.POST})
  DubboResult updateNewUser(@RequestParam(name = "userId") Long userId);
 
  /** 用户登录-吉林微法院直接登录 */
  @RequestMapping(value = "userLoginByMicroCourt", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLoginByMicroCourt(@RequestBody UserLoginByMicroCourtReqDTO req);
  
  /** 用户登录并注册 */
  @RequestMapping(value = "userLoginAndRegister", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> userLoginAndRegister(@RequestBody UserLoginAndRegisterReqDTO req);
  
  /**
   * 通过手机号码查找用户
   * @param mobilePhone 手机号码
   */
  @RequestMapping(value = "searchUserByMobile", method = {RequestMethod.POST})
  DubboResult<ArrayList<UserInfoDTO>> searchUserByMobile(@RequestParam(name = "mobilePhone") String mobilePhone);

  /**
   * 根据身份证号检查账号是否需要更新
   * @param req 手机号码
   */
  @RequestMapping(value = "checkAndUpdateByIdcard", method = {RequestMethod.POST})
  DubboResult checkAndUpdateByIdcard(@RequestBody UserLoginAndRegisterReqDTO req);
  /**
   * 获取用户登录信息
   */
  @RequestMapping(value = "getUserLoginById", method = {RequestMethod.POST})
  DubboResult<LoginInfoResDTO> getUserLoginById(@RequestBody CommonIdReqDTO req);
}
