package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;

/**
 * 调解类型枚举
 * @author zhiguang
 */
public enum MediationTypeEnum {
  PEOPLE_MEDIATION("人民调解"),
  ADMINISTRATION_MEDIATION("行政调解"),
  ARBITRATE_MEDIATION("仲裁调解"),
  JUDICIAL_MEDIATION("司法调解"),
  BUSINESS_MEDIATION("商业调解"),
  LAWYER_MEDIATION("律师调解"),
  NOTARIAL_MEDIATION("公证调解"),
  MAJOR_MEDIATION("专业调解"),
  INDUSTRY_MEDIATION("行业调解"),
  OTHER_MEDIATION("其他调解");
  
  private String name;

  MediationTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }
  
  public static String[] getNames() {
    MediationTypeEnum[] enums = MediationTypeEnum.values();
    String names[] = new String[enums.length];
    for (int i = 0; i < enums.length; i++) {
      names[i] = enums[i].getName();
    }
    return names;
  }
  
  public static HashMap<String, String> getNameEnumNameMap() {
    HashMap<String, String> map = new HashMap<String, String>();
    for (MediationTypeEnum type : MediationTypeEnum.values()) {
      map.put(type.getName(), type.name());
    }
    return map;
  }
}
