package com.beiming.odr.user.api.common.utils;

public class AreaUtil {

  /**
   * 通过区域code获取区域等级
   */
  public static Integer getAreaLevelByCode(String areaCode) {
    String prefixAreaCode = areaCode.replaceAll("0+$", "");
    if (prefixAreaCode.length() == 2) {
      return 1; //省
    } else if (prefixAreaCode.length() == 4 || prefixAreaCode.length() == 3) {
      return 2; //市
    } else if (prefixAreaCode.length() == 6 || prefixAreaCode.length() == 5) {
      return 3; //区、县
    } else if (prefixAreaCode.length() == 9 || prefixAreaCode.length() == 8 || prefixAreaCode.length() == 7) {
      return 4; //街道、乡镇
    } else if (prefixAreaCode.length() == 12 || prefixAreaCode.length() == 11 || prefixAreaCode.length() == 10) {
      return 5; //社区，村
    }
    return null;
  }
}
