package com.beiming.odr.user.api.common.utils;

import java.lang.reflect.Field;
import java.util.Base64;
import java.util.Base64.Decoder;
import java.util.Base64.Encoder;

/**
 * Created By IntelliJ IDEA
 *
 * @Description
 * @Author fangym
 * @Date 2019/7/10 0010上午 11:30
 */
public class BaseUtil {
  public static <T> T enCodeBean(T t) throws Exception {
    if (t == null) {
      return null;
    }
    Field[] fields = t.getClass().getDeclaredFields();
    for (int i = 0; i < fields.length; i++) {
      // 设置是否允许访问，不是修改原来的访问权限修饰词。
      fields[i].setAccessible(true);
      if (fields[i].getType().getTypeName().contains("String") && fields[i].get(t) != null) {
        fields[i].set(t, BaseUtil.encode(fields[i].get(t).toString()));
      }
    }
    return t;
  }

  /**
   * 加密
   */
  public static String encode(String str) {
    try {
      Encoder encoder = Base64.getEncoder();
      return encoder.encodeToString(str.getBytes("utf-8"));
    } catch (Exception e) {
      e.printStackTrace();
    }
    return "";
  }

  /**
   * 解密
   */
  public static String decode(String str) {
    try {
      Decoder decoder = Base64.getDecoder();
      byte[] bytes = decoder.decode(str);
      return new String(bytes, "utf-8");
    } catch (Exception e) {
      e.printStackTrace();
    }
    return "";
  }
}
