package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.BusinesPersonTypeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class UserInfoDTO implements Serializable {

  public UserInfoDTO(Long userId, String userName) {
    this.userId = userId;
    this.userName = userName;
  }

  public UserInfoDTO(Long userId, String userName, String mobilePhone, String personType,
      String status) {
    this.userId = userId;
    this.userName = userName;
    this.mobilePhone = mobilePhone;
    this.personType = personType;
    this.status = status;
  }

  public UserInfoDTO(Long userId, String loginName, String mobilePhone, String idCard,
      String userName, String headPortraitUrl, Boolean isRealName, Boolean isFacialVerify,
      String email, String personType, String sex, String businessPeopleType, String password) {
    this.userId = userId;
    this.loginName = loginName;
    this.mobilePhone = mobilePhone;
    this.idCard = idCard;
    this.userName = userName;
    this.headPortraitUrl = headPortraitUrl;
    if (isRealName == null) {
      isRealName = false;
    }
    this.isRealName = isRealName;
    if (isFacialVerify == null) {
      isFacialVerify = false;
    }
    this.isFacialVerify = isFacialVerify;
    this.email = email;
    this.personType = personType;
    this.sex = sex;
    if (BusinesPersonTypeEnum.PETITION_LETTER_AGENT.toString().equals(businessPeopleType)) {
      this.petitionLetterAgentFlag = true;
    } else {
      this.petitionLetterAgentFlag = false;
    }
    if (UserConst.COMMON_PASSWORD_MD5.equals(password)) {
      this.defaultPwdFlag = true;
    } else {
      this.defaultPwdFlag = false;
    }
  }

  /**
   * 人员类型
   */
  private String personType;
  /** 用户id */

  private Long userId;
  /**
   * 用户登录名
   */
  private String loginName;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 是否实名
   */
  private Boolean isRealName;

  /**
   * 是否完成人脸识别
   */
  private Boolean isFacialVerify;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 服务人员在线繁忙状态
   */
  private String servicePersonStatus;

  /**
   * 性别
   */
  private String sex;

  /**
   * 是否是信访用户
   */
  private Boolean petitionLetterAgentFlag;

  /**
   * 所属的角色类型
   */
  private String roleType;
  /***
   * 是否是默认密码 true是,false不是
   */
  private Boolean defaultPwdFlag;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 分平台
   */
  private String thirdType;
  /**
   * 分平台对应机构的id
   */
  private String thirdId;
  
  /**
   * 问候语名称
   */
  private String greetingName;

  /**
   * 上次登录时间
   */
  private String lastLoginTime;
}
