package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.constants.ValidateMessage;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.common.enums.ValuationCycleEnums;
import lombok.Data;

@Data
public class AddCapacityTemplateReqDTO implements Serializable {


  /**
   * 
   */
  private static final long serialVersionUID = 4670297491023308850L;

  private Integer id;

  private String sys;
  /**
   * 模板名称
   */
  @NotEmpty
  private String tempName;

  /**
   * 适用对象
   */
  @NotNull
  private ApplicableObjectEnums applicableObject;

  /**
   * 评估周期
   */
  @NotNull
  private ValuationCycleEnums evaluationCycle;

  /**
   * 处理率
   */
  @NotNull
  @Min(value = 1, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer completionPercent;

  /**
   * 满意度
   */
  @NotNull
  @Min(value = 1, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer satisfactionPercent;

  /**
   * 成功率
   */
  @NotNull
  @Min(value = 1, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer successPercent;

  /**
   * 1星最低分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer firstLevelStart;

  /**
   * 1星最高分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer firstLevelEnd;

  /**
   * 2星最低分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer secondLevelStart;

  /**
   * 2星最高分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer secondLevelEnd;

  /**
   * 3星最低分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer thirdLevelStart;

  /**
   * 3星最高分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer thirdLevelEnd;

  /**
   * 4星最低分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer fourthLevelStart;

  /**
   * 4星最高分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer fourthLevelEnd;

  /**
   * 5星最低分
   */
  @NotNull
  @Min(value = 0, message = ValidateMessage.LESS_THAN_0_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer fifthLevelStart;

  /**
   * 5星最高分
   */
  @NotNull
  @Min(value = 100, message = ValidateMessage.LESS_THAN_100_ERROR)
  @Max(value = 100, message = ValidateMessage.GREATER_THAN_100_ERROR)
  private Integer fifthLevelEnd;


  /**
   * 创建用户
   */
  @NotEmpty(message = ValidateMessage.OPRATOR_NULL_ERROR)
  private String createUser;

  /**
   * @return the 模板名称
   */
  public String getTempName() {
    return tempName;
  }

  /**
   * @param 模板名称 the temp_name to set
   */
  public void setTempName(String tempName) {
    this.tempName = tempName == null ? null : tempName.trim();
  }

  /**
   * @return the 适用对象
   */
  public ApplicableObjectEnums getApplicableObject() {
    return applicableObject;
  }

  /**
   * @param 适用对象 the applicable_object to set
   */
  public void setApplicableObject(ApplicableObjectEnums applicableObject) {
    this.applicableObject = applicableObject;
  }

  /**
   * @return the 评估周期
   */
  public ValuationCycleEnums getEvaluationCycle() {
    return evaluationCycle;
  }

  /**
   * @param 评估周期 the evaluation_cycle to set
   */
  public void setEvaluationCycle(ValuationCycleEnums evaluationCycle) {
    this.evaluationCycle = evaluationCycle;
  }

  /**
   * @return the 处理率
   */
  public Integer getCompletionPercent() {
    return completionPercent;
  }

  /**
   * @param 处理率 the completion_percent to set
   */
  public void setCompletionPercent(Integer completionPercent) {
    this.completionPercent = completionPercent;
  }

  /**
   * @return the 满意度
   */
  public Integer getSatisfactionPercent() {
    return satisfactionPercent;
  }

  /**
   * @param 满意度 the satisfaction_percent to set
   */
  public void setSatisfactionPercent(Integer satisfactionPercent) {
    this.satisfactionPercent = satisfactionPercent;
  }

  /**
   * @return the 成功率
   */
  public Integer getSuccessPercent() {
    return successPercent;
  }

  /**
   * @param 成功率 the success_percent to set
   */
  public void setSuccessPercent(Integer successPercent) {
    this.successPercent = successPercent;
  }

  /**
   * @return the 1星最低分
   */
  public Integer getFirstLevelStart() {
    return firstLevelStart;
  }

  /**
   * @param 1星最低分 the first_level_start to set
   */
  public void setFirstLevelStart(Integer firstLevelStart) {
    this.firstLevelStart = firstLevelStart;
  }

  /**
   * @return the 1星最高分
   */
  public Integer getFirstLevelEnd() {
    return firstLevelEnd;
  }

  /**
   * @param 1星最高分 the first_level_end to set
   */
  public void setFirstLevelEnd(Integer firstLevelEnd) {
    this.firstLevelEnd = firstLevelEnd;
  }

  /**
   * @return the 2星最低分
   */
  public Integer getSecondLevelStart() {
    return secondLevelStart;
  }

  /**
   * @param 2星最低分 the second_level_start to set
   */
  public void setSecondLevelStart(Integer secondLevelStart) {
    this.secondLevelStart = secondLevelStart;
  }

  /**
   * @return the 2星最高分
   */
  public Integer getSecondLevelEnd() {
    return secondLevelEnd;
  }

  /**
   * @param 2星最高分 the second_level_end to set
   */
  public void setSecondLevelEnd(Integer secondLevelEnd) {
    this.secondLevelEnd = secondLevelEnd;
  }

  /**
   * @return the 3星最低分
   */
  public Integer getThirdLevelStart() {
    return thirdLevelStart;
  }

  /**
   * @param 3星最低分 the third_level_start to set
   */
  public void setThirdLevelStart(Integer thirdLevelStart) {
    this.thirdLevelStart = thirdLevelStart;
  }

  /**
   * @return the 3星最高分
   */
  public Integer getThirdLevelEnd() {
    return thirdLevelEnd;
  }

  /**
   * @param 3星最高分 the third_level_end to set
   */
  public void setThirdLevelEnd(Integer thirdLevelEnd) {
    this.thirdLevelEnd = thirdLevelEnd;
  }

  /**
   * @return the 4星最低分
   */
  public Integer getFourthLevelStart() {
    return fourthLevelStart;
  }

  /**
   * @param 4星最低分 the fourth_level_start to set
   */
  public void setFourthLevelStart(Integer fourthLevelStart) {
    this.fourthLevelStart = fourthLevelStart;
  }

  /**
   * @return the 4星最高分
   */
  public Integer getFourthLevelEnd() {
    return fourthLevelEnd;
  }

  /**
   * @param 4星最高分 the fourth_level_end to set
   */
  public void setFourthLevelEnd(Integer fourthLevelEnd) {
    this.fourthLevelEnd = fourthLevelEnd;
  }

  /**
   * @return the 5星最低分
   */
  public Integer getFifthLevelStart() {
    return fifthLevelStart;
  }

  /**
   * @param 5星最低分 the fifth_level_start to set
   */
  public void setFifthLevelStart(Integer fifthLevelStart) {
    this.fifthLevelStart = fifthLevelStart;
  }

  /**
   * @return the 5星最高分
   */
  public Integer getFifthLevelEnd() {
    return fifthLevelEnd;
  }

  /**
   * @param 5星最高分 the fifth_level_end to set
   */
  public void setFifthLevelEnd(Integer fifthLevelEnd) {
    this.fifthLevelEnd = fifthLevelEnd;
  }

  /**
   * @return the 创建人
   */
  public String getCreateUser() {
    return createUser;
  }

  /**
   * @param 创建人 the create_user to set
   */
  public void setCreateUser(String createUser) {
    this.createUser = createUser == null ? null : createUser.trim();
  }
}
