package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import com.beiming.framework.page.PageQuery;
import lombok.Data;

/**
 * 查询诉求机构dto
 * @author zhiguang
 *
 */
@Data
public class AppealOrganizationListReqDTO extends PageQuery implements Serializable {
  
  private static final long serialVersionUID = 1286810156383513293L;

  /**
   * 诉求机构类型代码
   */
  @NotBlank
  private String appealOrgTypeCode;
  
  /**
   * 查询机构名称
   */
  private String searchOrgName;
  
  /**
   * 当前工单区域代码
   */
  @NotBlank
  private String currentAreaCode;
  
  /**
   * 步骤代码 
   * ASSIGN_ORG(分配机构),
   * TRANSFER_AREA(转移区域),
   * DOWN_AREA(下派区域),
   * SUBMIT_HIGHER(提交上级),
   * SUBMIT_PLATFORM(提交总平台)
   */
  @NotBlank
  private String activityCode;
  
  /**
   * 区域等级 调用方不传，由areaCode计算
   */
  private Integer areaLevel;
  
  /**
   * 需排除区域代码
   */
  private String excludeAreaCode;
  
  /**
   * 级别类型
   */
  private List<String> levelTypes;
  
  /**
   * 当前机构id
   */
  private Long currentOrgId;
  
  private List<Long> parentIds;
  
}
