package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import com.alibaba.fastjson.JSONArray;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.UserSexTypeEnum;
import lombok.Data;


/**
 * 工作人员新增参数
 */
@Data
public class BackstageUserAddReqDTO implements Serializable {
  
  /**
   * 用户id
   * */
  private Long userId;
  /**
   * 姓名
   */
  private String userName;

  /**
   * 账户名
   */
  private String loginName;

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  private String mobilePhone;

  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "身份证格式错误")
  private String idCard;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "密码格式错误")
  private String password;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 出生日期
   */
  private String birthday;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 职业类型
   */
  private String occupation;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 从业经历
   */
  private String experience;
  
  /**
   * 职业
   */
  private String job;


  /** 用户地址 */
  private JSONArray userAddress;

  /**
   * 平台职能
   */
  @NotEmpty(message = "平台职能不能为空")
  private JSONArray userRoleRelation;

  /**
   * 用户证件集合
   */
  private JSONArray userCertificates;
  /**
   * 性别
   */
  private UserSexTypeEnum sex;
  
  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 分平台
   */
  private String thirdType;
  /**
   * 分平台对应机构的id
   */
  private String thirdId;
  
  /**
   * 身份类型
   */
  private String identityType;

  
}
